(*| 11:52 28/02/1992 *)
PROGRAM LISTPROC;

USES
  Crt,Dos,Printer;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];
  MaxLine=String[255];

VAR
   SrcFileName,IncFileName: LineString;
   OptionString,ListFileName,TextLine: LineString;
   InUnit,InInterface,InImplementation: Boolean;
   Abort,Print,SaveToFile,InterfaceOnly,Both: Boolean;
   FindRec: SearchRec;
   Source,Include,List: Text;
   Sline:MaxLine;
   I,P1,P2: Integer;

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : ',
          'LISTPROC [D:][SrcFileName] [DestFileName] [/P][/D][/I][/B]');
  Writeln('Switches : /P    Copy output to printer');
  Writeln('           /D    Copy output to disk, default filename *.PRG');
  Writeln('           /I    Interface routines only');
  Writeln('           /B    Both interface and implementation routines');
  HALT;
END;  { ShowHelp }

FUNCTION ResultOK:Boolean;
VAR
  I:Integer;
BEGIN
  I:=IOResult;
  IF I = 0 THEN
    ResultOK:=True
  ELSE BEGIN
    ResultOK:=False;
    Writeln;
    Writeln('IOError #',I);
  END;
END;

PROCEDURE ProcessOptions;
BEGIN
  Print:=False;
  InterfaceOnly:=False;
  Both:=False;
  IF POS('/P',OptionString) > 0 THEN Print:=True;
  IF POS('/D',OptionString) > 0 THEN SaveToFile:=True;
  IF POS('/I',OptionString) > 0 THEN InterfaceOnly:=True;
  IF POS('/B',OptionString) > 0 THEN Both:=True;
END; { ProcessOptions }

FUNCTION AbortTest: Boolean;
VAR
  C:Char;
BEGIN
  IF KeyPressed THEN BEGIN
    C:=ReadKey;
    Writeln('Abort Y/N ? ');
    C:=ReadKey;
    IF UpCase(C) = 'Y' THEN Abort:=True;
    Writeln('Aborting');
  END;
  AbortTest:=Abort;
END; { AbortTest }

PROCEDURE Continue;
VAR
  C:Char;
BEGIN
  Writeln;
  Write('Press any key to continue');
  C:=ReadKey;
  Writeln;
  Writeln;
END;  { Continue }

PROCEDURE WriteSLine;
BEGIN
  Writeln(Sline);
  IF SaveToFile THEN
    Writeln(List,Sline);
  IF Print THEN
    Writeln(LST,Sline);
END;  { WriteSLine }

PROCEDURE WriteBlankLine;
VAR
  OldSline: MaxLine;
BEGIN
  OldSline:=Sline;
  Sline:='';
  WriteSline;
  Sline:=OldSline;
END;  { WriteBlankLine }

PROCEDURE ShowProcs;

VAR
  I,P1,P2,P3: Integer;
  Sline2:string[255];

BEGIN
  IF LENGTH(SLine) > 0 THEN IF SLine[1] <> ' ' THEN
    BEGIN
      SLine2:=Sline;
      FOR I:=1 TO LENGTH(SLine2) DO SLine2[I]:=UpCase(SLine2[I]);
      IF InUnit THEN
        BEGIN
          IF POS('INTERFACE',SLine2)=1 THEN BEGIN
            InInterface:=True;
            IF Both THEN BEGIN
              WriteBlankLine;
              WriteSline;
              WriteBlankLine;
            END;
          END;
          IF InInterface THEN BEGIN
            IF POS('IMPLEMENTATION',SLine2)=1 THEN BEGIN
              InImplementation:=True;
              InInterface:=False;
              IF Both THEN BEGIN
                WriteBlankLine;
                WriteSline;
                WriteBlankLine;
              END;
            END;
          END;
          IF InImplementation THEN BEGIN
            IF SLine2='END.' THEN
              InUnit:=False;
          END;
        END
      ELSE BEGIN
        IF POS('UNIT',SLine2)=1 THEN
        InUnit:=True;
      END;
      IF Both OR (InterFaceOnly  XOR NOT InInterface) THEN BEGIN
        P1:=POS('OVERLAY',SLine2);
        P2:=POS('PROCEDURE',SLine2);
        P3:=POS('FUNCTION',SLine2);
        IF (P1=1) OR (P2=1) OR (P3=1) THEN WriteSLine;
      END;
    END;
END;  {ShowProcs}

PROCEDURE ProcessFile(ThisFileName: LineString);
VAR
  ThisListName: LineString;
BEGIN
  ASSIGN(Source,ThisFileName);
  Reset(Source);
  IF SaveToFile THEN BEGIN
    IF Length(ListFileName) = 0 THEN BEGIN
      ThisListName := COPY(ThisFileName,1,POS('.',ThisFileName)) + 'PRG';
      Assign(List,ThisListName);
      Rewrite(List);
    END;
  END;
  WriteBlankLine;
  Sline := ThisFileName;
  WriteSline;
  WriteBlankLine;
  WHILE NOT EOF(Source) DO BEGIN
    Readln(Source,Sline);
    P1:=Pos('{$I',Sline);
    P2:=Pos('{$i',Sline);
    IF P1=0 THEN P1:=P2;
    IF (P1<> 0) THEN BEGIN
      P1:=P1+3;
      IF NOT (UpCase(Sline[P1]) IN ['+','-','F']) THEN
      BEGIN
        WHILE Sline[P1]=' ' DO P1:=P1+1;
        IncFileName:=Copy(Sline,P1,Pos('}',Sline)-P1);
        P2:=Pos('.',IncFileName);
        IF p2=0 THEN IncFileName:=Copy(IncFileName,1,8)+'.pas'
        ELSE BEGIN
          IF P2 >8 THEN IncFileName:=Copy(IncFileName,1,8)+Copy(IncFileName,P2,4);
        END;
        ASSIGN(Include,IncFileName);
        {$I-}
        Reset(Include);
        {$I+}
        IF IOResult <> 0 THEN
          BEGIN
            Writeln('Include File Error. File : ',IncFileName);
            Writeln('Line : ',SLine);
            Halt;
          END;
        WriteBlankLine;
        Sline :='Include File ' + IncFileName;
        WriteSline;
        WriteBlankLine;
        WHILE NOT EOF(Include) DO BEGIN
          Readln(Include,Sline);
          ShowProcs;
        END;
        Close(Include);
        Writeln;
        Writeln('End Of File ',IncFileName);
        Writeln;
      END;
     END
    ELSE BEGIN
      ShowProcs;
    END;
  END;
  Close(Source);
  IF SaveToFile AND (Length(ListFileName) = 0) THEN
    Close(List);
END;  {ProcessFile}

BEGIN
  Writeln('List Pascal Procedures Program by B Whitnall, V2.0');
  InUnit:=False;
  InInterface:=False;
  InImplementation:=False;
  OptionString:='';
  SaveToFile:=False;
  ListFileName:='';
  IF ParamCount = 0 THEN BEGIN
    Write('Source File Name:');
    Readln(SrcFileName);
  END ELSE FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        SrcFileName:=TextLine;
      IF I = 2 THEN BEGIN
        ListFileName:=TextLine;
        SaveToFile:=True;
        Assign(List,ListFileName);
        Rewrite(List);
      END;
    END;
  END;
  IF SrcFileName = '?' THEN
    ShowHelp;
  IF Pos('.',SrcFileName)=0 THEN SrcFileName:=SrcFileName+'.pas';
  ProcessOptions;
  IF (POS(':',SrcFileName) > 0) OR (POS('\',SrcFileName) > 0) THEN
    ProcessFile(SrcFileName)
  ELSE BEGIN
    FindFirst(SrcFileName,Archive,FindRec);
    WHILE DosError=0 DO BEGIN
      ProcessFile(FindRec.Name);
      FindNext(FindRec);
    END;
  END;
  IF Length(ListFileName) > 0 THEN
    Close(List);
END.
